/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.saverest.cloning;

import com.ibm.hwmca.base.saverest.cloning.CloningBean;
import com.ibm.hwmca.base.saverest.cloning.CloningConstants;
import com.ibm.hwmca.base.saverest.cloning.CloningErrorIds;
import com.ibm.hwmca.base.saverest.cloning.CloningSaveRestoreBean;
import com.ibm.hwmca.base.saverest.cloning.CloningUtil;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashMap;

public class CloningTasklet
extends PanelTasklet
implements CloningConstants,
CloningErrorIds {
    private static final String TRACE_MASKT = "XSRDCLTT";
    private static final String TRACE_MASKF = "XSRDCLTF";
    private static final String TRACE_MASKD = "XSRDCLTD";
    private CloningUtil cloningUtil;

    public void logException(Throwable throwable) {
        new FrameworkLog(CloningErrorIds._logInfo, 257, throwable).log();
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> CloningTasklet.service()");
        String command = (String)request.getData("event");
        if (command == null) {
            command = "";
        }
        if (request.isInitialRequest()) {
            this.handleInitial(request, response);
        } else if (request.isDisposed() || request.isCanceled()) {
            Trace.trace(TRACE_MASKT, "Terminating the tasklet");
            response.terminate();
        } else if (command.equals("NextButton")) {
            this.handleMachineSelection(request, response);
        } else if (command.equals("SaveButton")) {
            this.handleSave(request, response);
        } else if (command.equals("RestoreButton")) {
            this.handleRestore(request, response);
        } else if (command.equals("NetworkModeItem")) {
            response.noAction();
        } else if (command.equals("LocalModeItem")) {
            response.redirect("com.ibm.hwmca.base.saverest.SaveRestoreTasklet");
        } else if (command.equals("ConfigureItem")) {
            response.openModalChild(new DisplayAreaDescriptorDelegate("com.ibm.hwmca.base.saverest.cloning.CloningSettingsTasklet", null));
        } else if (command.equals("showMessage")) {
            String msgid = (String)request.getData("showMessage");
            if (msgid == null) {
                response.error(new LocalizableText("Unknown state!  No message to display"), command);
            } else {
                Object[] args = (String[])request.getData("showMessage_args");
                MessageText mt = msgid.startsWith("XSRD") ? new MessageText("com.ibm.hwmca.base.saverest.cloning.res.cloning_message", msgid, args) : new MessageText("com.ibm.hwmca.base.saverest.res.saveresttext", msgid, args);
                this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.base.saverest.res.SaveRestoreRes", "SaveRestorePanel.TEXT"), new MessageText[]{mt}, mt.getMsgId(), MsgType.ERROR_MESSAGE, new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
                response.noAction();
            }
        } else {
            throw new TaskletException("Unknown state!");
        }
    }

    private void handleInitial(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        block4: {
            Trace.trace(TRACE_MASKT, "-> CloningTasklet.handleInitial()");
            try {
                this.cloningUtil = new CloningUtil();
                CloningBean cloningBean = new CloningBean();
                cloningBean.setBeanName("CloningBean");
                HashMap<String, LocalizableText[]> data = new HashMap<String, LocalizableText[]>();
                LocalizableText[] machines = this.cloningUtil.getSupportingMachines();
                data.put("MachineTable", machines);
                cloningBean.setData(data);
                if (machines.length == 0) {
                    Trace.trace(TRACE_MASKF, "no machines available");
                    this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.base.saverest.cloning.res.cloning_message", "XSRD.NOMACHINES.TITLE"), new MessageText("com.ibm.hwmca.base.saverest.cloning.res.cloning_message", "XSRD.NOMACHINES.MSG"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
                    response.redirect("com.ibm.hwmca.base.saverest.SaveRestoreTasklet");
                    response.terminate();
                } else {
                    response.replace("com.ibm.hwmca.base.saverest.cloning.res.CloningRes", "CloningPanel", cloningBean);
                }
            }
            catch (Exception e) {
                new FrameworkLog(CloningErrorIds._logInfo, 258, e).log(FrameworkLogAttributes.INFO_LOG);
                if (response.isResponseSet()) break block4;
                response.terminate();
            }
        }
        Trace.trace(TRACE_MASKT, "<- CloningTasklet.handleInitial()");
    }

    private void handleMachineSelection(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        block2: {
            Trace.trace(TRACE_MASKT, "-> handleMachineSelection()");
            try {
                this.cloningUtil.setSelectedMachines((LocalizableText[])request.getData("MachineTable"));
                CloningSaveRestoreBean saveRestoreBean = new CloningSaveRestoreBean();
                saveRestoreBean.setBeanName("SaveRestBean");
                String[][] info = this.cloningUtil.getItemDescriptorRawData();
                saveRestoreBean.setItemDescriptorInfo(info[0], info[1]);
                response.replace("com.ibm.hwmca.base.saverest.res.SaveRestoreRes", "SaveRestorePanel", saveRestoreBean);
            }
            catch (Exception e) {
                new FrameworkLog(CloningErrorIds._logInfo, 263, e).log(FrameworkLogAttributes.INFO_LOG);
                if (response.isResponseSet()) break block2;
                response.terminate();
            }
        }
        Trace.trace(TRACE_MASKT, "<- handleMachineSelection()");
    }

    private void handleSave(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        block3: {
            Trace.trace(TRACE_MASKT, "-> handleSave()");
            try {
                this.showBusyDialog(new LocalizableText("com.ibm.hwmca.base.saverest.res.SaveRestoreRes", "SaveRestorePanel.TEXT"), new LocalizableText("com.ibm.hwmca.base.saverest.res.SaveRestoreRes", "SaveRestoreBusy.ExecutingMessage"));
                String[] selectedItems = (String[])request.getData("items");
                CompletionReport[] reports = this.cloningUtil.cloneItems(selectedItems);
                this.destroyBusyDialog();
                MachineId[] machines = this.cloningUtil.getSelectedMachineIds();
                String subst = "";
                int i = 0;
                while (i < machines.length) {
                    subst = subst + "\n" + machines[i].getName();
                    ++i;
                }
                MessageText mt = new MessageText("com.ibm.hwmca.base.saverest.res.saveresttext", "xsrd.file.saved.to", new String[]{subst});
                this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.base.saverest.res.SaveRestoreRes", "SaveRestorePanel.TEXT"), new MessageText[]{mt}, mt.getMsgId(), mt.getMsgType(), new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
                response.noAction();
            }
            catch (Exception e) {
                new FrameworkLog(CloningErrorIds._logInfo, 264, e).log(FrameworkLogAttributes.INFO_LOG);
                if (response.isResponseSet()) break block3;
                response.terminate();
            }
        }
        Trace.trace(TRACE_MASKT, "<- handleSave()");
    }

    private void handleRestore(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        block3: {
            Trace.trace(TRACE_MASKT, "-> handleRestore()");
            try {
                this.showBusyDialog(new LocalizableText("com.ibm.hwmca.base.saverest.res.SaveRestoreRes", "SaveRestorePanel.TEXT"), new LocalizableText("com.ibm.hwmca.base.saverest.res.SaveRestoreRes", "SaveRestoreBusy.ExecutingMessage"));
                String[] selectedItems = (String[])request.getData("items");
                CompletionReport report = this.cloningUtil.beCloned(selectedItems);
                this.destroyBusyDialog();
                Trace.trace(TRACE_MASKF, "report:" + report.toString());
                MachineId[] machines = this.cloningUtil.getSelectedMachineIds();
                String subst = "";
                int i = 0;
                while (i < machines.length) {
                    subst = subst + "\n" + machines[i].getName();
                    ++i;
                }
                MessageText mt = new MessageText("com.ibm.hwmca.base.saverest.res.saveresttext", "xsrd.data.restored.from", new String[]{subst});
                this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.base.saverest.res.SaveRestoreRes", "SaveRestorePanel.TEXT"), new MessageText[]{mt}, mt.getMsgId(), mt.getMsgType(), new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
                response.noAction();
            }
            catch (Exception e) {
                new FrameworkLog(CloningErrorIds._logInfo, 265, e).log(FrameworkLogAttributes.INFO_LOG);
                if (response.isResponseSet()) break block3;
                response.terminate();
            }
        }
        Trace.trace(TRACE_MASKT, "<- handleRestore()");
    }
}

